-- V2D-173675
SET SQL_SAFE_UPDATES = 0;
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='HOMEWORK_ASSIGNMENT_STUDENT_ADHOC');
update `sql_dtprovider` set `sqlQuery` = "SELECT 
    T1.id AS ID,
    T6.id AS DATA_ID,
    T4.firstName AS FIRST_NAME,
    T4.lastName AS LAST_NAME,
    T4.printName AS PRINT_NAME,
    T4.emailId AS EMAIL_ID,
    T4.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T4.mobileNumber AS MOBILE_NO,
    T4.mobileCountryCode AS MOBILE_CODE,
    T5.academyName AS ACADEMY_NAME,
    T5.locationName AS LOCATION_NAME,
    T5.displayName AS ACADEMY_NAME_LOCATION,
    T6.assignmentName AS ASSIGNMENT_NAME,
    T8.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
    T8.courseCode AS COURSE_CODE,
    T7.courseVariantCode AS COURSE_VARIANT_CODE,
    T7.courseVariantDescription AS COURSE_VARIANT_DESCRIPTION,
    DATE_FORMAT(T6.dateSubmitted, '%d-%m-%Y %H:%i:%s') AS CURRENT_DATE_TIME,
   	group_concat(distinct CONCAT(f.devicePlatForm,'/',f.deviceTokenId)) AS DEVICE_ID,
    'HOMEWORK_ASSIGNMENTS' AS MSG_CATEGORY
FROM
    group_hw_assignment T1
        LEFT JOIN
    admission AS T2 ON T2.id = T1.admissionId
        LEFT JOIN
    students AS T3 ON T3.userId = T2.studentId
        LEFT JOIN
    persons AS T4 ON T4.id = T3.personId
        LEFT JOIN
    academy_location T5 ON T5.id = T2.academyLocationId
        LEFT JOIN
    course_hw_asignment T6 ON T6.id = T1.hwAssignmentId
        LEFT JOIN
    course_variants T7 ON T7.id = T6.courseVariantId
        LEFT JOIN
    courses T8 ON T8.id = T7.courseId
        LEFT JOIN
    fire_base_persons_info f ON f.userId = T3.userId
WHERE
    T1.id IN (namedParams) group by T1.admissionId " where `dataProviderId` = @dtproviderId;
    
    
SET @eventUpdate=(SELECT id FROM msg_template_config WHERE `code`='Homework Assignment Allocation');
INSERT INTO `msg_template` (`msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) VALUES (@eventUpdate, '6', 'Take Home Assignment', 'Take-home assignment has been given to you for $recipientData["COURSE_CODE"]/$recipientData["COURSE_NAME_TO_BE_PRINTED"]. The submission deadline is $recipientData["CURRENT_DATE_TIME"].');

UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;],</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"> Take home assignment has been given to you for $recipientData["COURSE_CODE"]/$recipientData["COURSE_NAME_TO_BE_PRINTED"]. The submission
deadline is $recipientData["CURRENT_DATE_TIME"]. Please log in to Student Portal for more details.</span></span></p>

			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="https://www.serosoft.com/mailer/academiaerp-logo-red.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`=@eventUpdate and msgDeliveryModeId in (1);


UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;],</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"> Take home assignment has been given to you for $recipientData["COURSE_CODE"]/$recipientData["COURSE_NAME_TO_BE_PRINTED"]. The submission
deadline is $recipientData["CURRENT_DATE_TIME"].</span></span></p>

			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="https://www.serosoft.com/mailer/academiaerp-logo-red.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`=@eventUpdate and msgDeliveryModeId in (4);


SET SQL_SAFE_UPDATES = 1;


